/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.data;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public final class AnimationBinary {
    private static final byte keyframeSize = 9;

    public static <T extends ByteBuffer> T write(KeyframeAnimation animation, T buf, int version) throws BufferOverflowException {
        buf.putInt(animation.beginTick);
        buf.putInt(animation.endTick);
        buf.putInt(animation.stopTick);
        AnimationBinary.putBoolean(buf, animation.isInfinite());
        buf.putInt(animation.returnToTick);
        AnimationBinary.putBoolean(buf, animation.isEasingBefore);
        AnimationBinary.putBoolean(buf, animation.nsfw);
        buf.put((byte)9);
        if (version >= 2) {
            buf.putInt(animation.getBodyParts().size());
            for (Map.Entry<String, KeyframeAnimation.StateCollection> part : animation.getBodyParts().entrySet()) {
                AnimationBinary.putString(buf, part.getKey());
                AnimationBinary.writePart(buf, part.getValue(), version);
            }
        } else {
            AnimationBinary.writePart(buf, animation.getPart("head"), version);
            AnimationBinary.writePart(buf, animation.getPart("body"), version);
            AnimationBinary.writePart(buf, animation.getPart("rightArm"), version);
            AnimationBinary.writePart(buf, animation.getPart("leftArm"), version);
            AnimationBinary.writePart(buf, animation.getPart("rightLeg"), version);
            AnimationBinary.writePart(buf, animation.getPart("leftLeg"), version);
        }
        buf.putLong(animation.getUuid().getMostSignificantBits());
        buf.putLong(animation.getUuid().getLeastSignificantBits());
        return buf;
    }

    public static <T extends ByteBuffer> T write(KeyframeAnimation animation, T buf) throws BufferOverflowException {
        return AnimationBinary.write(animation, buf, AnimationBinary.getCurrentVersion());
    }

    private static void writePart(ByteBuffer buf, KeyframeAnimation.StateCollection part, int version) {
        AnimationBinary.writeKeyframes(buf, part.x, version);
        AnimationBinary.writeKeyframes(buf, part.y, version);
        AnimationBinary.writeKeyframes(buf, part.z, version);
        AnimationBinary.writeKeyframes(buf, part.pitch, version);
        AnimationBinary.writeKeyframes(buf, part.yaw, version);
        AnimationBinary.writeKeyframes(buf, part.roll, version);
        if (part.isBendable) {
            AnimationBinary.writeKeyframes(buf, part.bendDirection, version);
            AnimationBinary.writeKeyframes(buf, part.bend, version);
        }
    }

    private static void writeKeyframes(ByteBuffer buf, KeyframeAnimation.StateCollection.State part, int version) {
        List<KeyframeAnimation.KeyFrame> list = part.getKeyFrames();
        if (version >= 2) {
            AnimationBinary.putBoolean(buf, part.isEnabled());
            buf.putInt(list.size());
        } else {
            buf.putInt(part.isEnabled() ? list.size() : -1);
        }
        if (part.isEnabled() || version >= 2) {
            for (KeyframeAnimation.KeyFrame move : list) {
                buf.putInt(move.tick);
                buf.putFloat(move.value);
                buf.put(move.ease.getId());
            }
        }
    }

    public static KeyframeAnimation read(ByteBuffer buf, int version) throws IOException {
        KeyframeAnimation.AnimationBuilder animation = new KeyframeAnimation.AnimationBuilder(AnimationFormat.BINARY);
        animation.beginTick = buf.getInt();
        animation.endTick = buf.getInt();
        animation.stopTick = buf.getInt();
        animation.isLooped = AnimationBinary.getBoolean(buf);
        animation.returnTick = buf.getInt();
        animation.isEasingBefore = AnimationBinary.getBoolean(buf);
        animation.nsfw = AnimationBinary.getBoolean(buf);
        byte keyframeSize = buf.get();
        if (keyframeSize <= 0) {
            throw new IOException("keyframe size must be greater than 0, current: " + keyframeSize);
        }
        boolean valid = true;
        if (version >= 2) {
            int count = buf.getInt();
            for (int i = 0; i < count; ++i) {
                String name = AnimationBinary.getString(buf);
                KeyframeAnimation.StateCollection part = animation.getOrCreatePart(name);
                valid = AnimationBinary.readPart(buf, part, version, keyframeSize) && valid;
            }
        } else {
            valid = AnimationBinary.readPart(buf, animation.head, version, keyframeSize);
            valid = AnimationBinary.readPart(buf, animation.body, version, keyframeSize) && valid;
            valid = AnimationBinary.readPart(buf, animation.rightArm, version, keyframeSize) && valid;
            valid = AnimationBinary.readPart(buf, animation.leftArm, version, keyframeSize) && valid;
            valid = AnimationBinary.readPart(buf, animation.rightLeg, version, keyframeSize) && valid;
            valid = AnimationBinary.readPart(buf, animation.leftLeg, version, keyframeSize) && valid;
        }
        long msb = buf.getLong();
        long lsb = buf.getLong();
        animation.uuid = new UUID(msb, lsb);
        animation.extraData.put("valid", valid);
        return animation.build();
    }

    private static boolean readPart(ByteBuffer buf, KeyframeAnimation.StateCollection part, int version, int keyframeSize) {
        boolean bl = AnimationBinary.readKeyframes(buf, part.x, version, keyframeSize);
        bl = AnimationBinary.readKeyframes(buf, part.y, version, keyframeSize) && bl;
        bl = AnimationBinary.readKeyframes(buf, part.z, version, keyframeSize) && bl;
        bl = AnimationBinary.readKeyframes(buf, part.pitch, version, keyframeSize) && bl;
        bl = AnimationBinary.readKeyframes(buf, part.yaw, version, keyframeSize) && bl;
        boolean bl2 = bl = AnimationBinary.readKeyframes(buf, part.roll, version, keyframeSize) && bl;
        if (part.isBendable()) {
            bl = AnimationBinary.readKeyframes(buf, part.bendDirection, version, keyframeSize) && bl;
            bl = AnimationBinary.readKeyframes(buf, part.bend, version, keyframeSize) && bl;
        }
        return bl;
    }

    private static boolean readKeyframes(ByteBuffer buf, KeyframeAnimation.StateCollection.State part, int version, int keyframeSize) {
        int length;
        boolean enabled;
        boolean valid = true;
        if (version >= 2) {
            enabled = AnimationBinary.getBoolean(buf);
            length = buf.getInt();
        } else {
            length = buf.getInt();
            enabled = length >= 0;
        }
        for (int i = 0; i < length; ++i) {
            int currentPos = buf.position();
            if (!part.addKeyFrame(buf.getInt(), buf.getFloat(), Ease.getEase(buf.get()))) {
                valid = false;
            }
            buf.position(currentPos + keyframeSize);
        }
        part.setEnabled(enabled);
        return valid;
    }

    public static int getCurrentVersion() {
        return 2;
    }

    public static int calculateSize(KeyframeAnimation animation, int version) {
        int size = 36;
        if (version < 2) {
            size += AnimationBinary.partSize(animation.getPart("head"), version);
            size += AnimationBinary.partSize(animation.getPart("body"), version);
            size += AnimationBinary.partSize(animation.getPart("rightArm"), version);
            size += AnimationBinary.partSize(animation.getPart("leftArm"), version);
            size += AnimationBinary.partSize(animation.getPart("rightLeg"), version);
            size += AnimationBinary.partSize(animation.getPart("leftLeg"), version);
        } else {
            size += 4;
            for (Map.Entry<String, KeyframeAnimation.StateCollection> entry : animation.getBodyParts().entrySet()) {
                size += AnimationBinary.stringSize(entry.getKey()) + AnimationBinary.partSize(entry.getValue(), version);
            }
        }
        return size;
    }

    private static int stringSize(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        return bytes.length + 4;
    }

    private static int partSize(@Nullable KeyframeAnimation.StateCollection part, int version) {
        int size = 0;
        size += AnimationBinary.axisSize(part.x, version);
        size += AnimationBinary.axisSize(part.y, version);
        size += AnimationBinary.axisSize(part.z, version);
        size += AnimationBinary.axisSize(part.pitch, version);
        size += AnimationBinary.axisSize(part.yaw, version);
        size += AnimationBinary.axisSize(part.roll, version);
        if (part.isBendable) {
            size += AnimationBinary.axisSize(part.bend, version);
            size += AnimationBinary.axisSize(part.bendDirection, version);
        }
        return size;
    }

    private static int axisSize(KeyframeAnimation.StateCollection.State axis, int version) {
        return axis.getKeyFrames().size() * 9 + (version >= 2 ? 5 : 4);
    }

    public static void putBoolean(ByteBuffer byteBuffer, boolean bl) {
        byteBuffer.put((byte)(bl ? 1 : 0));
    }

    public static boolean getBoolean(ByteBuffer buf) {
        return buf.get() != 0;
    }

    public static void putString(ByteBuffer buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    public static String getString(ByteBuffer buf) {
        int len = buf.getInt();
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

